import { Tooltip } from "antd";

const SettingsTooltip = ( { content } ) => {
    return (
        // Make re-usable tooltip for settings.
        <Tooltip placement="top" title={ content }>
            <div className={ `settings-tooltip` } style={ { display: 'flex' } }>
                <svg width="12" height="13" fill="none">
                    <path
                        fill="#73829d"
                        d="M10.8.5H1.2a1.18 1.18 0 0 0-.846.354A1.18 1.18 0 0 0 0 1.7v7.2a1.18 1.18 0 0 0 .354.846 1.18 1.18 0 0 0 .846.354h2.4L6 12.5l2.4-2.4h2.4a1.18 1.18 0 0 0 .846-.354c.222-.228.354-.528.354-.846V1.7a1.18 1.18 0 0 0-.354-.846A1.18 1.18 0 0 0 10.8.5zM1.2 8.9V1.7h9.6v7.2H7.902L6 10.802 4.098 8.9m.732-5.976c.324-.216.75-.324 1.284-.324.564 0 1.014.126 1.338.372a1.21 1.21 0 0 1 .486 1.008c0 .264-.09.498-.264.72-.174.216-.402.384-.678.51-.156.09-.258.18-.312.282-.054.108-.084.24-.084.408H5.4c0-.3.06-.504.174-.648.126-.144.33-.312.642-.504a1.19 1.19 0 0 0 .384-.324.79.79 0 0 0 .132-.444c0-.18-.054-.312-.162-.414-.108-.108-.27-.156-.456-.156a.69.69 0 0 0-.414.126c-.096.084-.156.21-.156.378H4.362c-.03-.414.138-.774.468-.99zM5.4 7.7V6.5h1.2v1.2H5.4z"
                    />
                </svg>
            </div>
        </Tooltip>
    );
}

export default SettingsTooltip;
