<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
global $post;

if ( ! comments_open() ) {
	return;
}

?>
<div id="reviews">
	
	<div id="comments">
		<?php if ( have_comments() ) : ?>

			<ol class="comment-list">
				<?php wp_list_comments( array( 'callback' => array( 'WP_Freeio_Review', 'freelancer_comments' ) ) ); ?>
			</ol>

			<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) :
				echo '<nav class="apus-pagination">';
				paginate_comments_links( apply_filters( 'apus_comment_pagination_args', array(
					'prev_text' => '&larr;',
					'next_text' => '&rarr;',
					'type'      => 'list',
				) ) );
				echo '</nav>';
			endif; ?>

		<?php else : ?>

			<p class="apus-noreviews text-danger"><?php esc_html_e( 'Il n\'y a pas encore d\'avis.', 'wp-freeio' ); ?></p>

		<?php endif; ?>
	</div>
	<?php $commenter = wp_get_current_commenter(); ?>
	<div id="review_form_wrapper" class="commentform">
		<div id="review_form">
			<?php
				$comment_form = array(
					'title_reply'          => have_comments() ? esc_html__( 'Ajouter un avis', 'wp-freeio' ) : sprintf( esc_html__( 'Soyez le premier à donner votre avis &ldquo;%s&rdquo;', 'wp-freeio' ), get_the_title() ),
					'title_reply_to'       => esc_html__( 'Laisser une réponse à %s', 'wp-freeio' ),
					'comment_notes_before' => '',
					'comment_notes_after'  => '',
					'fields'               => array(
						'author' => '<div class="row"><div class="col-xs-12 col-sm-12"><div class="form-group"><label>'.esc_html__( 'Nom', 'wp-freeio' ).'</label>'.
						            '<input id="author" placeholder="'.esc_attr__( 'Votre nom', 'wp-freeio' ).'" class="form-control" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30" aria-required="true" /></div></div>',
						'email'  => '<div class="col-xs-12 col-sm-12"><div class="form-group"><label>'.esc_html__( 'Email', 'wp-freeio' ).'</label>' .
						            '<input id="email" placeholder="'.esc_attr__( 'votre@mail.com', 'wp-freeio' ).'" class="form-control" name="email" type="text" value="' . esc_attr(  $commenter['comment_author_email'] ) . '" size="30" aria-required="true" /></div></div></div>',
					),
					'label_submit'  => esc_html__( 'Soumettre l\'avis', 'wp-freeio' ),
					'logged_in_as'  => '',
					'comment_field' => ''
				);

				$comment_form['must_log_in'] = '<div class="must-log-in">' .  __( 'Vous devez être <a href="">connecté</a> pour poster un avis.', 'wp-freeio' ) . '</div>';
				
				$comment_form['comment_field'] .= '<div class="form-group"><label>'.esc_html__( 'Avis', 'wp-freeio' ).'</label><textarea id="comment" class="form-control" placeholder="'.esc_attr__( 'Write Comment', 'wp-freeio' ).'" name="comment" cols="45" rows="5" aria-required="true"></textarea></div>';
				
				comment_form($comment_form);
			?>
		</div>
	</div>
</div>