<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$user_id = get_current_user_id();
?>
<li class="<?php echo esc_attr($rpost->post_author == $user_id ? 'yourself-reply' : 'user-reply'); ?> author-id-<?php echo esc_attr($rpost->post_author); ?>">
  <?php if ( $rpost->post_author != $user_id ) { ?>
    <div class="avatar">
      <?php freeio_user_avarta( $rpost->post_author ); ?>
    </div>
  <?php } ?>
  <div class="reply-content">
    <!-- date -->
    <?php
      $pdate = get_the_time( get_option('date_format'), $rpost );
      $current = strtotime(date("Y-m-d"));
      $date    = strtotime( get_the_time('Y-m-d', $rpost) );

      $datediff = $date - $current;
      $difference = floor($datediff/(60*60*24));
      if ( $difference == 0 ) {
        $date = esc_html__('Today', 'freeio');
      } elseif ( $difference == -1 ) {
        $date = esc_html__('Yesterday', 'freeio');
      }
    ?>
    <div class="post-date"><?php echo trim($pdate); ?>, <?php echo get_the_time( get_option('time_format'), $rpost ); ?></div>
    <div class="post-content">
      <?php echo esc_html($rpost->post_content); ?>
      <?php
      $attachments = get_post_meta($rpost->ID, '_attachments', true);
      if ( !empty($attachments) ) {
        $download_base_url = admin_url( 'admin-ajax.php' );
        ?>
        <div class="attachments">
          <?php
          foreach ($attachments as $id => $cv_url) {
                  $file_info = pathinfo($cv_url);
                  if ( $file_info ) {
                    $download_url = add_query_arg(array('file_id' => $id, 'post_id' => $rpost->ID, 'action' => 'wp_private_message_download_attachments'), $download_base_url);
                  ?>
                    <div class="item">
                        <a href="<?php echo esc_url($download_url); ?>" class="d-inline-block type-file-message">
                            <span class="icon_type pre d-inline-block text-theme">
                                <i class="flaticon-file"></i>
                            </span>
                            <?php if ( !empty($file_info['basename']) ) { ?>
                                <span class="filename"><?php echo esc_html($file_info['basename']); ?></span>
                            <?php } ?>
                        </a>
                      </div>
                  <?php }
              } ?>
        </div>
        <?php
      }
      ?>    
    </div>
  </div>
  
</li>